<?php
 /**
 * Horizontal scrolling announcements
 *
 * @package 	Horizontal scrolling announcements
 * @subpackage 	mod_horizontal_scrolling_announcements
 * @version   	3.7
 * @author    	Gopi Ramasamy
 * @copyright 	Copyright (C) 2010 - 2020 www.gopiplus.com, LLC
 * @license   	GNU General Public License version 2 or later; see LICENSE.txt
 *
 * http://www.gopiplus.com/extensions/2018/02/horizontal-scrolling-announcements-joomla-module/
 */ 

defined('_JEXEC') or die;

$hsa_speed 		= (int) $params->get('hsa_speed', 10);
$hsa_gap 		= (int) $params->get('hsa_gap', 50);
$hsa_direction 	= $params->get('hsa_direction', 'left');

if(!is_numeric($hsa_speed)) {
	$hsa_speed = 20000;
} else {
	$hsa_speed = $hsa_speed * 1000;
}

if (!is_numeric($hsa_gap)) { 
	$hsa_gap = 50; 
}

$randnumber = mt_rand(10,100);

$height = "";
if($hsa_direction == "up" || $hsa_direction == "down") {
	//$height = "height: 0px";
}

$marqueecontent = "";

if ( ! empty($items) ) 
{
	foreach ( $items as $item ) 
	{
		$hsa_news	=  $item->hsa_news;
		$hsa_link	=  $item->hsa_link;
		
		$scrolltxt = "";
		if($hsa_link == ""){
			$scrolltxt = stripslashes($hsa_news);
		} 
		else {
			$scrolltxt = '<a href="'.$hsa_link.'">'.stripslashes($hsa_news).'</a>';
		}
		
		$marqueecontent = $marqueecontent . "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" . $scrolltxt;
	}
	?>
	<div class='marquee-hsas-<?php echo $randnumber; ?>' style='max-width: 100%;overflow: hidden;<?php echo $height; ?>'>
		<?php echo $marqueecontent; ?>
	</div>
	<script>
	jQuery(function(){
		jQuery('.marquee-hsas-<?php echo $randnumber; ?>').marquee({
			allowCss3Support: true,
			css3easing: 'linear',
			easing: 'linear',
			delayBeforeStart: 2000,
			direction: '<?php echo $hsa_direction; ?>',
			duplicated: true,
			duration: <?php echo $hsa_speed; ?>,
			gap: <?php echo $hsa_gap; ?>,
			pauseOnCycle: true,
			pauseOnHover: true,
			startVisible: true
		});
	});
	</script>
	<?php
}
?>